<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-pencil me-2"></i>Edit Project
    </h2>
    <a href="<?= base_url('admin/projects') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/projects/update/' . $project['id']) ?>" method="POST" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="nama_project" class="form-label">Nama Project <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_project" name="nama_project" 
                       value="<?= old('nama_project', $project['nama_project']) ?>" required>
            </div>
            <div class="col-md-3 mb-3">
                <label for="jenis_project" class="form-label">Jenis Project <span class="text-danger">*</span></label>
                <select class="form-select" id="jenis_project" name="jenis_project" required>
                    <option value="">Pilih Jenis</option>
                    <option value="Web" <?= old('jenis_project', $project['jenis_project']) === 'Web' ? 'selected' : '' ?>>Web</option>
                    <option value="Mobile" <?= old('jenis_project', $project['jenis_project']) === 'Mobile' ? 'selected' : '' ?>>Mobile</option>
                    <option value="Game" <?= old('jenis_project', $project['jenis_project']) === 'Game' ? 'selected' : '' ?>>Game</option>
                    <option value="Desktop" <?= old('jenis_project', $project['jenis_project']) === 'Desktop' ? 'selected' : '' ?>>Desktop</option>
                    <option value="Lainnya" <?= old('jenis_project', $project['jenis_project']) === 'Lainnya' ? 'selected' : '' ?>>Lainnya</option>
                </select>
            </div>
            <div class="col-md-3 mb-3">
                <label for="tahun" class="form-label">Tahun</label>
                <input type="number" class="form-control" id="tahun" name="tahun" 
                       value="<?= old('tahun', $project['tahun'] ?? '') ?>" min="1900" max="2100" placeholder="Contoh: 2023">
            </div>
        </div>

        <div class="mb-3">
            <label for="teknologi" class="form-label">Teknologi</label>
            <textarea class="form-control" id="teknologi" name="teknologi" rows="2" 
                      placeholder="Contoh: PHP, JavaScript, React, MySQL"><?= old('teknologi', $project['teknologi'] ?? '') ?></textarea>
        </div>

        <div class="mb-3">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi
            </label>
            
            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                      placeholder="Tulis deskripsi atau klik Generate AI untuk membuat otomatis..."><?= old('deskripsi', $project['deskripsi'] ?? '') ?></textarea>
            
            <!-- AI Generate Button -->
            <button type="button" class="btn btn-outline-primary btn-sm position-absolute ai-generate-btn" 
                    style="top: 35px; right: 10px; z-index: 10;" 
                    id="generateDescriptionBtn" onclick="generateProjectDescription()">
                <i class="bi bi-magic" id="generateIcon"></i>
                <span id="generateText">Generate AI</span>
            </button>
            
            <!-- AI Status -->
            <div class="ai-status mt-2" id="aiStatus" style="display: none;">
                <div class="alert alert-info alert-sm">
                    <i class="bi bi-robot me-1"></i>
                    <span id="aiStatusText">Sedang menggenerate deskripsi...</span>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="link_project" class="form-label">Link Project</label>
                <input type="url" class="form-control" id="link_project" name="link_project" 
                       value="<?= old('link_project', $project['link_project'] ?? '') ?>" placeholder="https://...">
            </div>
            <div class="col-md-3 mb-3">
                <label for="urutan" class="form-label">Urutan</label>
                <input type="number" class="form-control" id="urutan" name="urutan" 
                       value="<?= old('urutan', $project['urutan'] ?? 0) ?>" min="0">
            </div>
            <div class="col-md-3 mb-3">
                <label for="foto" class="form-label">Foto Project</label>
                <?php if ($project['foto'] ?? null): ?>
                    <div class="mb-2">
                        <img src="<?= image_url('projects', $project['foto'], 200, 150) ?>" 
                             alt="Foto saat ini" style="max-width: 200px; border-radius: 5px;"
                             onerror="this.src='<?= base_url('placeholder/200/150') ?>'; this.onerror=null;">
                        <p class="text-white small mt-1">Foto saat ini</p>
                    </div>
                <?php endif; ?>
                <input type="file" class="form-control" id="foto" name="foto" 
                       accept="image/jpeg,image/png,image/gif">
                <small class="text-white">Format: JPG, PNG, GIF (Max: 2MB). Kosongkan jika tidak ingin mengubah.</small>
            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Update
            </button>
            <a href="<?= base_url('admin/projects') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>

<script src="<?= base_url('assets/js/ai-generator.js') ?>"></script>
<script>
// Initialize AI Generator UI for Projects Edit
document.addEventListener('DOMContentLoaded', function() {
    // Auto-fill AI input when nama_project changes
    const namaProject = document.getElementById('nama_project');
    if (namaProject) {
        namaProject.addEventListener('input', function() {
            const aiInput = document.getElementById('aiInput');
            if (aiInput && this.value) {
                aiInput.value = `Saya mengerjakan proyek "${this.value}". Tolong buatkan deskripsi yang menjelaskan fitur, teknologi, dan tujuan dari proyek ini.`;
            }
        });
    }
});
</script>


